<?php

/**
 * Class that operate on table 'projectexchmaterialdetailreturn'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-07-03 12:01
 */
class ProjectexchmaterialdetailreturnMySqlDAO implements ProjectexchmaterialdetailreturnDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ProjectexchmaterialdetailreturnMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM projectexchmaterialdetailreturn WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM projectexchmaterialdetailreturn';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM projectexchmaterialdetailreturn ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param projectexchmaterialdetailreturn primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM projectexchmaterialdetailreturn WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ProjectexchmaterialdetailreturnMySql projectexchmaterialdetailreturn
     */
    public function insert($projectexchmaterialdetailreturn) {
        $sql = 'INSERT INTO projectexchmaterialdetailreturn (projectexchid, productid, pronumber, probuyprice, expensestypeid, supervision_amount, supervision) VALUES (?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($projectexchmaterialdetailreturn->projectexchid);
        $sqlQuery->setNumber($projectexchmaterialdetailreturn->productid);
        $sqlQuery->setNumber($projectexchmaterialdetailreturn->pronumber);
        $sqlQuery->setNumber($projectexchmaterialdetailreturn->probuyprice);
        $sqlQuery->setNumber($projectexchmaterialdetailreturn->expensestypeid);
        $sqlQuery->setNumber($projectexchmaterialdetailreturn->supervision_amount);
        $sqlQuery->setNumber($projectexchmaterialdetailreturn->supervision);
        $id = $this->executeInsert($sqlQuery);
        $projectexchmaterialdetailreturn->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ProjectexchmaterialdetailreturnMySql projectexchmaterialdetailreturn
     */
    public function update($projectexchmaterialdetailreturn) {
        $sql = 'UPDATE projectexchmaterialdetailreturn SET projectexchid = ?, productid = ?, pronumber = ?, probuyprice = ?, expensestypeid = ?, supervision_amount = ?, supervision = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($projectexchmaterialdetailreturn->projectexchid);
        $sqlQuery->setNumber($projectexchmaterialdetailreturn->productid);
        $sqlQuery->setNumber($projectexchmaterialdetailreturn->pronumber);
        $sqlQuery->setNumber($projectexchmaterialdetailreturn->probuyprice);
        $sqlQuery->setNumber($projectexchmaterialdetailreturn->expensestypeid);
        $sqlQuery->setNumber($projectexchmaterialdetailreturn->supervision_amount);
        $sqlQuery->setNumber($projectexchmaterialdetailreturn->supervision);

        $sqlQuery->setNumber($projectexchmaterialdetailreturn->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM projectexchmaterialdetailreturn';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByProjectexchid($value) {
        $sql = 'SELECT * FROM projectexchmaterialdetailreturn WHERE projectexchid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductid($value) {
        $sql = 'SELECT * FROM projectexchmaterialdetailreturn WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPronumber($value) {
        $sql = 'SELECT * FROM projectexchmaterialdetailreturn WHERE pronumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByProjectexchid($value) {
        $sql = 'DELETE FROM projectexchmaterialdetailreturn WHERE projectexchid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductid($value) {
        $sql = 'DELETE FROM projectexchmaterialdetailreturn WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPronumber($value) {
        $sql = 'DELETE FROM projectexchmaterialdetailreturn WHERE pronumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ProjectexchmaterialdetailreturnMySql
     */
    protected function readRow($row) {
        $projectexchmaterialdetailreturn = new Projectexchmaterialdetailreturn();

        $projectexchmaterialdetailreturn->id = isset($row['id']) ? $row['id'] : '';
        $projectexchmaterialdetailreturn->projectexchid = isset($row['projectexchid']) ? $row['projectexchid'] : '';
        $projectexchmaterialdetailreturn->productid = isset($row['productid']) ? $row['productid'] : '';
        $projectexchmaterialdetailreturn->pronumber = isset($row['pronumber']) ? $row['pronumber'] : '';
        $projectexchmaterialdetailreturn->probuyprice = isset($row['probuyprice']) ? $row['probuyprice'] : '';
        $projectexchmaterialdetailreturn->expensestypeid = isset($row['expensestypeid']) ? $row['expensestypeid'] : '';
        $projectexchmaterialdetailreturn->supervision_amount = isset($row['supervision_amount']) ? $row['supervision_amount'] : '';
        $projectexchmaterialdetailreturn->supervision = isset($row['supervision']) ? $row['supervision'] : '';

        return $projectexchmaterialdetailreturn;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ProjectexchmaterialdetailreturnMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>